package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.persistence.Query;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.DocumentReviewStatus;
import gov.va.vinci.dart.db.DocumentReviewStatusDAO;

public class DocumentReviewStatusDAOMock implements DocumentReviewStatusDAO {

	private boolean initialized = false;
	private int idCounter = 1;
	private HashMap<Integer,DocumentReviewStatus> IDHash = new HashMap<Integer,DocumentReviewStatus>();
	
	@Override
	public void save(DocumentReviewStatus status) {
		if (status == null) {
			throw new IllegalArgumentException();
		}
		
		initializeStatusHash();
		
		if (status.getId() == 0) {
			status.setId(idCounter++);
		}

		IDHash.put(status.getId(), status);
	}

	@Override
	public DocumentReviewStatus findById(int documentId, int reviewerId,
			int groupId) throws ObjectNotFoundException {
		initializeStatusHash();

		for (Integer id: IDHash.keySet()) {
			DocumentReviewStatus status = IDHash.get(id);
			if (status.getDocument().getId() == documentId
				&& status.getReviewer().getId() == reviewerId
				&& status.getGroup().getId() == groupId) {
				return status;
			}
		}
		
		throw new ObjectNotFoundException();
	}
	
    @Override
    public int countGroupId(final int documentId, final int groupId) throws ObjectNotFoundException {
        /*Query q = createNativeQuery("SELECT count(*) FROM [hib].[documentreviewstatus] status where status.documentid=:did and status.groupid=:gid");
        q.setParameter("did", documentId);
		q.setParameter("gid", groupId);
        int iVal = (Integer) q.getSingleResult();*/

        return 1;
    }
	
	@Override
	public DocumentReviewStatus findByGroupId(int documentId, int groupId) throws ObjectNotFoundException {
		initializeStatusHash();

		for (Integer id: IDHash.keySet()) {
			DocumentReviewStatus status = IDHash.get(id);
			if (status.getDocument().getId() == documentId
				&& status.getGroup().getId() == groupId) {
				return status;
			}
		}
		
		throw new ObjectNotFoundException();
	}

	@Override
	public List<DocumentReviewStatus> listByReviewerId(int reviewerId) {
		initializeStatusHash();
		
		List<DocumentReviewStatus> result = new ArrayList<DocumentReviewStatus>();
		
		for (Integer id: IDHash.keySet()) {
			DocumentReviewStatus status = IDHash.get(id);
			if (status.getReviewer().getId() == reviewerId) {
				result.add(status);
			}
		}

		return result;	
	}

	private void initializeStatusHash() {
		if (initialized == true) {
			return;
		}
		initialized = true;
	}

}
